package inc.monsters.mias;

import inc.monsters.mias.data.Employee;
import inc.monsters.mias.data.Kid;

import java.util.Map;

import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;

public class Util {
	@SuppressWarnings("unchecked")
	public static Map<Integer, Kid> getKidsMap() {
		return (Map<Integer, Kid>) executeValueExpression( "#{kidsList.kidsWitKeys}", Map.class);
	}
	
	@SuppressWarnings("unchecked")
	public static Map<Integer, Employee> getEmployeesMap() {
		return (Map<Integer, Employee>) executeValueExpression( "#{empsList.employeesWitKeys}", Map.class);
	}
	
	public static Object executeValueExpression(String expression, Class<?> type) {
		FacesContext ctx = FacesContext.getCurrentInstance();
		Application app = ctx.getApplication();
		ExpressionFactory fact = app.getExpressionFactory();
		ValueExpression exp = fact.createValueExpression(ctx.getELContext(), expression, type);
		return exp.getValue(ctx.getELContext());
	}
	

}
